/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity.utils;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;

public class WrapperVelocity {
    public static ISRCommandSender wrapCommandSender(final CommandSource sender) {
        return new ISRCommandSender(){

            @Override
            public void sendMessage(String message) {
                sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message));
            }

            @Override
            public String getName() {
                return WrapperVelocity.getSenderName(sender);
            }

            @Override
            public boolean hasPermission(String permission) {
                return sender.hasPermission(permission);
            }

            @Override
            public boolean isConsole() {
                return sender instanceof ConsoleCommandSource;
            }
        };
    }

    public static ISRProxyPlayer wrapPlayer(final Player player) {
        return new ISRProxyPlayer(){

            @Override
            public Optional<String> getCurrentServer() {
                return player.getCurrentServer().map(server -> server.getServerInfo().getName());
            }

            @Override
            public void sendDataToServer(String channel, byte[] data) {
                player.getCurrentServer().map(server -> server.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)channel), data));
            }

            @Override
            public PlayerWrapper getWrapper() {
                return new PlayerWrapper(player);
            }

            @Override
            public String getName() {
                return player.getUsername();
            }

            @Override
            public void sendMessage(String message) {
                player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message));
            }

            @Override
            public boolean hasPermission(String permission) {
                return player.hasPermission(permission);
            }
        };
    }

    private static String getSenderName(CommandSource source) {
        return source instanceof Player ? ((Player)source).getUsername() : "CONSOLE";
    }
}

